/************************************************************************************
* This module contains some basic init code.
* Note! Basic code is adapted (start08.h and hidef.h) from some code developed by Metrowerks.
* 
*
*
* (c) Copyright 2006, Freescale Semiconductor, Inc. All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
************************************************************************************/

#ifndef _CRT0_H
#define _CRT0_H

/***********************************************************************************/

#include "EmbeddedTypes.h"


/***********************************************************************************/

#define STACK_FILL 1            /* init stack */
#define STACK_INIT_VALUE  0x55  /* stack init value */
// System Options Register 1
//                                   .--------- COPE     : COP Watchdog disabled
//                                   |.-------- COPT     : COP Watchdog Timeout. Short timeout period selected.
//                                   ||.------- STOPE    : Stop Mode disabled.
//                                   |||...---- X        : Unimplemented or Reserved.
//                                   ||||||.--- BKGDPE   : Background Debug Mode Pin Enable. PTA4/ACMP1O/BKGD/MS pin functions as BKGD/MS.
//                                   |||||||.-- RSTPE    : RESET Pin Enable. PTA5/IRQ/TPM1CLK/RESET pin functions as PTA5, IRQ or TPM1CLK.
//                                   ||||||||
#define SYSTEMS_OPTION_REG_VALUE   0b00100010
// System Options Register 2
//                                   .--------- COPCLKS  : COP Watchdog Clock Select. Internal 1 kHz clock is source to COP.
//                                   |..------- X        : Unimplemented or Reserved
//                                   |||.------ SPIFE    : SPI Ports Input Filter Enable. Enable input filter on SPI port pins to eliminate noise and restrict maximum SPI baud rate
//                                   ||||.----- SPIPS    : SPI Pin Select. SPSCLK on PTB2, MOSI on PTB3, MISO on PTB4, and SS on PTB5.
//                                   |||||.---- ACIC2    : Analog Comparator 2 to Input Capture Enable. ACMP2 output not connected to TPM2 input channel 0.
//                                   ||||||.--- IICPS    : IIC Pin Select. SDA on PTA2, SCL on PTA3.
//                                   |||||||.-- LSBFE    : Analog Comparator 1 to Input Capture Enable. ACMP output not connected to TPM1 input channel 0.
//                                   ||||||||
#define SYSTEMS_OPTION2_REG_VALUE  0b00001000

// Definitions for none-volatile registers.
#define NV_BACKKEY_LENGTH     8
#define NV_RESERVED_LENGTH    5
#define NV_FTRIM_VALUE        0x00
#define NV_TRIM_VALUE         0xAE  
#define NV_RESERVED1_VALUE    0xFF
#define NV_PROT_VALUE         0xFF
#define NV_OPT_VALUE	     	  0xFE
#define NV_BACKKEY_VALUE    0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF,0xFF
#define NV_RESERVED_VALUE   0xFF,0xFF,0xFF,0xFF,0xFF

#define FAR  // Empty - for tiny FAR is used as segment modifier
#define _FAR __far

#define toCopyDownBegOffs          0

// Only 2 flags are define
#define STARTUP_FLAGS_NONE         0
#define STARTUP_FLAGS_ROM_LIB      (1<<0)  // If module is a ROM library
#define STARTUP_FLAGS_NOT_INIT_SP  (1<<1)  // If stack pointer has not to be initialized

// LibInits is only used for ROM libraries
#define INCLUDE_ROM_LIBRARIES      0 // Switch on to implement ROM libraries

/**********************************************************************/
// Types

//NV register type
typedef struct NV_REG
{
  uint8_t nv_ftrim;
  uint8_t nv_trim;
	uint8_t	nv_backkey[NV_BACKKEY_LENGTH];
	uint8_t	nv_reserved[NV_RESERVED_LENGTH];
	uint8_t	nv_prot;
	uint8_t	nv_reserved1; // This value must/should be calibrated by production test system.
	uint8_t	nv_opt;
} NV_REG_t;

//  the following datastructures contain the data needed to
//  initialize the processor and memory 

typedef struct
{
	unsigned char *_FAR beg;
	int size; // [beg..beg+size]
} _Range;

typedef struct _Copy
{
	int size;
	unsigned char *_FAR dest;
} _Copy;

typedef void (*_PFunc)(void);

#ifdef INCLUDE_ROM_LIBRARIES
	typedef struct _LibInit
	{
		_PFunc  *startup; // Address of startup desc
	} _LibInit;
#endif INCLUDE_ROM_LIBRARIES

// attention: the linker scans the debug information for this structures
// to obtain the available fields and their sizes.
// So dont change the names in this file.

typedef struct _tagStartup
{
	unsigned char   flags; 					// STARTUP_FLAGS_xxx
	_PFunc          main;  					// Top level procedure of user program
	unsigned short  stackOffset; 			// Initial value of the stack pointer
	unsigned short  nofZeroOuts;			// Number of zero out ranges
	_Range          *_FAR pZeroOut;			// Vector of ranges with nofZeroOuts elements
	_Copy           *_FAR toCopyDownBeg;	// ROM-address where copydown-data begins

#if INCLUDE_ROM_LIBRARIES
	unsigned short  nofLibInits; 	        // number of library startup descriptors
	_LibInit        *_FAR libInits;         // Vector of pointers to library startup descriptors
#endif INCLUDE_ROM_LIBRARIES

} _startupData_t;    


/**********************************************************************/
extern void main(void);

/* Place it in NON_BANKED memory */
#ifdef MEMORY_MODEL_BANKED
#pragma CODE_SEG __NEAR_SEG NON_BANKED
#else
#pragma CODE_SEG DEFAULT
#endif /* MEMORY_MODEL_BANKED */
extern void _Startup (void);
extern void Init(void);
#pragma CODE_SEG DEFAULT

#define STARTUP_DATA		_startupData


#define CALL_MAIN_INTERFACE		Init();\
								main();	// Call user "main" function


/**********************************************************************/
// Prototypes data

extern const volatile NV_REG_t none_volatile_struct;

/**********************************************************************/
// Prototypes

/* Place it in NON_BANKED memory */
#ifdef MEMORY_MODEL_BANKED
#pragma CODE_SEG __NEAR_SEG NON_BANKED
#else
#pragma CODE_SEG DEFAULT
#endif /* MEMORY_MODEL_BANKED */
	extern void _Startup (void); // DO NOT CHANGE FUNCTION NAME
#pragma CODE_SEG DEFAULT	
	extern void Copy_startup_structure(_startupData_t * copy_structure);
	extern _startupData_t _startupData; // Stored in flash
	extern _startupData_t _startupData_var;

extern void NVM_FindNVRAM(void);

/**********************************************************************/

#endif _CRT0_H

